<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserMessage extends Model 
{

    protected $table = 'user_messages';
    public $timestamps = true;
    protected $fillable = array('user_id', 'chat_room_id', 'user_id_to', 'text', 'message_status');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function chatRoom()
    {
        return $this->belongsTo('App\Models\ChatRoom', 'chat_room_id');
    }

}